/**
 * @fileoverview address list page control
 * @author sunnyjiang
 * @version 1.0
 */

/**
 * @namespace address list
 */
var addressList = {};

addressList.timer = null;
addressList.keywords = '';

addressList.init = function() {

	// added by yinzhou
	// 初始化作短暂延时后拿到皮肤页面提高效率
	setTimeout("addressList.getForegroundPage()", 300);

	// 回调：方法1, 当输入时调用此方法；方法2, 当点击地址栏下拉按钮时调用此方法
	browser.skin.addressbar.init(addressList.callback, addressList.callback);
};

addressList.callback = function(returnData) {
//	addressList.test(new Date() + returnData);

	clearTimeout(addressList.timer); // 如果有数据返回，取消清空下拉列表内容

	returnData = eval('(' + returnData + ')');

	var addressListheight = addressList.bulidAddressList(returnData);
	
	browser.skin.addressbar.adjustHeight(addressListheight);
};

/**
 * show address list
 */
addressList.toggleAddressList = function() {
	var addressListElement = $('#address-list');
	
	if(addressList.css('display') == 'none') {
		addressbar.bulidAddressList();
		
		layout.adjustAddressList();
		addressList.show();
		
		// 页面点击隐藏address list
		$(window).bind('click', function() {
			addressListElement.hide();	
		});
		
	} else {
		addressListElement.hide();	
	}
};

/**
 * 创建下拉列表并显示
 */
addressList.bulidAddressList = function(data) {
	var inputId = data[0]; // 传递到上层进行比对
	var addressListData = data[1]; 
	var keywords = data[2]; // 关键字
	var extId = data[3]; // 作为删除方法的第一个参数
	var matchResult = data[4];
	
	var addressListUl = $('#address-list-ul');
	var addressMoreUl = $('#address-more-ul'); // 用于保存多余项的ul，删除时从中移到address list ul中
//	addressListUl.disableSelection();
	
	var addressListUlHTML = '';
	var addressMoreUlHTML = '';

	var maxIndex = addressListData.length >= 6 ? 6 : addressListData.length; // modified by yinzhou, 最多显示六项结果
	
	// 构造数据
	for(var i = 0; i < addressListData.length; i++) {
		var addressData = addressListData[i];
		var title = unescape(addressData.title);
		var url = unescape(addressData.url);
		var id = addressData.id;		
		var favicon = addressData.icon;
		
		var logoDivText = 
			'<div class="address-list-logo">' + 
				'<img onerror="this.src=\'images/tab/QBrowserDefault.png\'" src="' + favicon + '" /></div>';
		
		// 现在都可以删除
		var closeButtonHtml = '<div class="address-list-close-button" onmousedown="view.setCloseButtonPressed(this)"></div>';

		var highlightTitle = utils.encodeHtml(title);
		var highlightUrl = utils.encodeHtml(url);

		if(keywords) {
			highlightTitle = highlightTitle.replaceAll(keywords, '<span>' + keywords + '</span>');
			highlightUrl = highlightUrl.replaceAll(keywords, '<span>' + keywords + '</span>');
		}

		var liHTML = 
				'<li url="' + escape(url) + '" id="' + id + '">' +
					logoDivText + 
					'<div class="address-list-info">' + 
						'<div class="address-list-title">' + highlightTitle + '</div>' +
						'<div class="address-list-url">' + highlightUrl + '</div>' +										
					'</div>' +
					closeButtonHtml +
					'<div style="clear: both"></div>' +
				'</li>';
		if(i < maxIndex) {
			addressListUlHTML += liHTML;
		} else {
			addressMoreUlHTML += liHTML;
		}
	}
	
	// 构造底部搜索引擎列表
/*	addressListUlHTML += '<li class="address-list-menu" id="address-list-menu">';

	for(var i = 0; i < addressListSearchListData.length; i++) {
		var addressListSearch = addressListSearchListData[i];
		var style = addressListSearch.selected == 1 ? ' class="selected"' : ''; // 从配置中获取
		addressListUlHTML += '<img src="' + addressListSearch.icon + '"' + style + ' />';
	}
	
	addressListUlHTML += '</li>';*/

/*	var addressListMenuHTML =
			'<li class="address-list-menu" id="address-list-menu">' +
				'<img src="images/addressbar/www.soso.com_favicon.ico" class="selected" />' +
				'<img src="images/addressbar/www.baidu.com_favicon.ico" />' +
				'<img src="images/addressbar/www.google.com_favicon.ico" />' +
			'</li>';*/
	
	addressListUl.html(addressListUlHTML);

//	addressMoreUl.html(addressMoreUlHTML);

	addressListUl.data('id', extId); // 设置ul的id
	
	// 绑定li的点击事件
	var ul = $('#address-list-ul');
	ul.unbind('click').bind("click", function() {
		addressList.clickList(this);
	});
	
	// modified by yinzhou
	// 只有构建关键字匹配结果时才需要自动补全及显示搜索条目;
	// 当自动补全不为空时搜索条目显示在第二条;
	// 当自动补全为空时搜索条目显示在第一条;
	if (keywords && (keywords != '')) {
		addressList.keywords = keywords;
		var searchLogoDivText = '<div class="address-list-logo"><img src = "images/addressbar/icon_search.png"/></div>';
		var searchLi = 	'<li url="qqbrowser:search">' +
					searchLogoDivText + 
					'<div class="address-list-info">' + 
						'<div class="address-list-title">搜索: <span>' + utils.encodeHtml(unescape(keywords)) + '</span></div>' +
						'<div class="address-list-url">按shift + enter搜索</div>' +										
					'</div>' +
					'<div style="clear: both"></div>' +
				'</li>';

        // 没有匹配到任何数据仅显示搜索条目
		if (addressListData.length == 0) {
			addressListUl.html(searchLi);
			addressList.setAddressInput(keywords, 'nomatch');
		}
        // inputId = 10000表明按下了delete|backspace键，这时不要自动补全
		else if(matchResult != '' && inputId != 10000) { 
			addressList.selectDown('', keywords + matchResult);
			$(searchLi).insertAfter($(' li:first-child', addressListUl));

		} else {
			$(searchLi).insertAfter($(' li:first-child', addressListUl));
			addressList.setAddressInput(keywords, 'nomatch');
		}
	}
	else {
		addressList.setAddressInput('', 'nomatch');
	}
//	$('#address-list-menu').html($('#address-list-menu').html() + addressListUl.outerHeight());
//	alert([$(window).height(), $(body).height(), addressListUl.outerHeight()]);

	return addressListUl.outerHeight() == 317 ? 330 : addressListUl.outerHeight(); // 临时解决第一次打开高度不对的问题
};

//added by yinzhou
//前台皮肤页面只需获取一次，保存住，提高效率
var foregroundPage = null;
addressList.getForegroundPage = function() {
	if (foregroundPage != null)	{
		return foregroundPage;
	}

	try	{
		var pageList = qqbrowser.extension.getPages(qqbrowser.window.currentId(), ["foreground"]);
		foregroundPage = pageList[0];
	}
	catch (e){
	}

	return foregroundPage;
};

// 打开后设置输入框为第一项
// type为select时，是上下选择，需要选择全部输入文字
addressList.setAddressInput = function(url, type, firstUrl) {
	if(!firstUrl) {
		firstUrl = '';
	}

	try {
		addressList.getForegroundPage().executeScript("", "addressbar.fillAddress('" + escape(url) + "', '" + type + "', '" + firstUrl + "')");	
	} catch(e) {
//		alert(e.message);
	}
};

// 打开网址
addressList.openUrl = function(url, search) {
	try {
		search = search ? search : 0;
		addressList.getForegroundPage().executeScript("", "addressbar.openUrl('" + escape(url) + "', 1, " + ((search == 1) ? "1" : "0") + ");");	
	} catch(e) {
		//alert(e.message);
	}
};

/**
 * 点击下拉列表里的栏目
 */
addressList.clickList = function(addressLi) {
	var element = $(event.target);

	// 判断是删除按钮还是点击地址
	if(element.is('.address-list-close-button')) {
		var li = element.parent();

		var itemId = li.attr('id');
		var extId = unescape($('#address-list-ul').data('id'));

		li.remove();
		
		// 调整高度
		if (document.getElementById('address-list-ul').hasChildNodes())	{
			browser.skin.addressbar.adjustHeight($('#address-list-ul').outerHeight());
		} else {
			browser.skin.addressbar.adjustHeight(0);
		}			
		
		// 通知浏览器删除
		browser.skin.addressbar.deleteResult(extId, itemId);

		// 下面再补一项
//		$('#address-list-ul').append($('#address-more-ul li:first-child'));
		
		return false; // 取消冒泡
/*	} else if(element.is('#address-list-menu img')) { // TODO 搜索引擎切换
		// 设置配置

		// 切换引擎，页面不消失
		$('#address-list-menu img.selected').removeClass('selected');
		element.addClass('selected'); */
	} else {
		while(!element.is('li')) {
			element = element.parent();
		}

		var url = unescape(element.attr('url'));

		if(url) {
			// modified by yinzhou
			if (url == 'qqbrowser:search') {
				addressList.openUrl(addressList.keywords, 1);
			} else {
				addressList.openUrl(url);			
			}
		}
		// set address input bar
//		$('#address-input').val(url);
		
		// hide address list
//		$('#address-list').hide();
		
		// call open url api
//		addressbar.openUrl();
	}
};

addressList._inputDownStatus = false; // 设置当前是不是选中地址栏输入状态的标志，用于向下选择
addressList._inputUpStatus = false; // 设置当前是不是选中地址栏输入状态的标志，用于向上选择

//选择上一项，并设置address input
addressList.selectUp = function() {
	var liOldHover = $('#address-list-ul li.hover');
	var liNewHover = liOldHover.prev();
		
	if(!liNewHover.length && addressList._inputUpStatus) { // 没有当前选中，没有下一个选中，此时是地址栏输入状态
		//  选中最后一项
		liNewHover = $('#address-list-ul li:last-child');

		addressList._inputUpStatus = false;
		addressList._inputDownStatus = false;
	} else if(!liNewHover.length) { // 此时是在地址栏下拉第一项
		// 回到地址栏状态
		addressList.setAddressInput(null, "input");

		liOldHover.removeClass('hover');

		addressList._inputUpStatus = true;
		return;
	}
	
	var url = unescape($(liNewHover).attr('url'));
	
	if(liNewHover && url && url != 'undefined') {
		liOldHover.removeClass('hover');
		liNewHover.addClass('hover');
		
		addressList.setAddressInput(url, "select");
	}
};

// 选择下一项，并设置address input
// type为select时，是上下键选择，地址栏补全逻辑为地址栏设置为选中的url并全部选定
addressList.selectDown = function(type, match) {
	var liOldHover = $('#address-list-ul li.hover');
	var liNewHover = liOldHover.next();

//	debug(liNewHover.html());
	if(!liOldHover.length || (!liNewHover.length && addressList._inputDownStatus)) { // 尚未选中或者是地址栏输入状态
		liNewHover = $('#address-list-ul li:first-child');

		addressList._inputUpStatus = false;
		addressList._inputDownStatus = false;
	} else if(!liNewHover.length) { // 此时是在地址栏下拉最后一项
		// 回到地址栏状态
		addressList.setAddressInput(null, "input");

		liOldHover.removeClass('hover');

		addressList._inputDownStatus = true;
		return;
	}
	
	var url = match ? match : unescape($(liNewHover).attr('url'));
	var firstUrl = match ? unescape($(liNewHover).attr('url')) : '';

	if(liNewHover && url && url != 'undefined') {
		liOldHover.removeClass('hover');
		liNewHover.addClass('hover');
		
		addressList.setAddressInput(url, type, firstUrl);
	}
};

/**
 * 延迟清空内容，如果有数据返回，取消清空
 */
addressList.delayClearList = function() {
	addressList.timer = setTimeout("addressList.clearList()", 100);
};

/**
 * 清空地址栏内容
 */
addressList.clearList = function() {
	$('#address-list-ul').html('');

	browser.skin.addressbar.adjustHeight(-1);
};


function debug(text) {
	$('li.address-list-menu').html(escape(text));
}


$(function() {
	addressList.init();
});

document.onselectstart = document.ondragstart = function() {
	return false;
};